
/*
  CLASSiC DAC, Copyright 2013 SILICON CHIP Publications
  Infrared.h: interrupt-based functions to decode Philips RC5 and NEC IR commands
  Written by Nicholas Vinen, 2009-2013
*/

#ifndef _INFRARED_H_
#define _INFRARED_H_

#include "types.h"

#define IR_NOCODE 0x00000000L
#define IR_REPEAT 0x00800000L
#define IR_CODE(x) ((x)&0xFF7FFFFFL)
#define IR_RC5 0x00010000L
#define IR_NEC 0x00020000L
#define RC5(x) ((x)|IR_RC5)
#define NEC(x) ((x)|IR_NEC)

// codes for Altronics A1012 ("DynaLink") remote control on "TV" setting 156
#define RC5_A1012_TV156_STANDBY		0x008C
#define RC5_A1012_TV156_MUTE		0x008D

#define RC5_A1012_TV156_1			0x0081
#define RC5_A1012_TV156_2			0x0082
#define RC5_A1012_TV156_3			0x0083
#define RC5_A1012_TV156_4			0x0084
#define RC5_A1012_TV156_5			0x0085
#define RC5_A1012_TV156_6			0x0086
#define RC5_A1012_TV156_7			0x0087
#define RC5_A1012_TV156_8			0x0088
#define RC5_A1012_TV156_9			0x0089
#define RC5_A1012_TV156_0			0x0080

#define RC5_A1012_TV156_CHUP		0x008A
#define RC5_A1012_TV156_CHDN		0x008B
#define RC5_A1012_TV156_VOLUP		0x0090
#define RC5_A1012_TV156_VOLDN		0x0091

#define RC5_A1012_TV156_UP			0x0092
#define RC5_A1012_TV156_DOWN		0x0093
#define RC5_A1012_TV156_LEFT		0x0095
#define RC5_A1012_TV156_RIGHT		0x0094
#define RC5_A1012_TV156_OK			0x00A3

#define RC5_A1012_TV156_TELETEXT	0x00BF
#define RC5_A1012_TV156_PAGEHOLD	0x00A9
#define RC5_A1012_TV156_TVVIDEO		0x00AD
#define RC5_A1012_TV156_TVTEXT		0x00AE // same as record

#define RC5_A1012_TV156_OSD			0x00BE
#define RC5_A1012_TV156_RECORD		0x00AE
#define RC5_A1012_TV156_PAUSE		0x00B5
#define RC5_A1012_TV156_EXIT		0x008B

#define RC5_A1012_TV156_RW			0x00B7
#define RC5_A1012_TV156_PLAY		0x00B2
#define RC5_A1012_TV156_FF			0x00B4
#define RC5_A1012_TV156_STOP		0x00B6

// codes for Altronics A1012 ("DynaLink") remote control on "TV" setting 170
#define RC5_A1012_TV170_STANDBY		0x000C
#define RC5_A1012_TV170_MUTE		0x000D

#define RC5_A1012_TV170_1			0x0001
#define RC5_A1012_TV170_2			0x0002
#define RC5_A1012_TV170_3			0x0003
#define RC5_A1012_TV170_4			0x0004
#define RC5_A1012_TV170_5			0x0005
#define RC5_A1012_TV170_6			0x0006
#define RC5_A1012_TV170_7			0x0007
#define RC5_A1012_TV170_8			0x0008
#define RC5_A1012_TV170_9			0x0009
#define RC5_A1012_TV170_0			0x0000

#define RC5_A1012_TV170_CHUP		0x0020
#define RC5_A1012_TV170_CHDN		0x0021
#define RC5_A1012_TV170_VOLUP		0x0010
#define RC5_A1012_TV170_VOLDN		0x0011

#define RC5_A1012_TV170_UP			0x0012
#define RC5_A1012_TV170_DOWN		0x0013
#define RC5_A1012_TV170_LEFT		0x0015
#define RC5_A1012_TV170_RIGHT		0x0014
#define RC5_A1012_TV170_OK			0x0023

#define RC5_A1012_TV170_TELETEXT	0x003C
#define RC5_A1012_TV170_PAGEHOLD	0x0029
#define RC5_A1012_TV170_TVVIDEO		0x003F
#define RC5_A1012_TV170_TVTEXT		0x002E // same as record
#define RC5_A1012_TV170_OSD			0x000F
#define RC5_A1012_TV170_RECORD		0x002E
#define RC5_A1012_TV170_PAUSE		0x003D
#define RC5_A1012_TV170_EXIT		0x000B
#define RC5_A1012_TV170_RW			0x0037
#define RC5_A1012_TV170_PLAY		0x0032
#define RC5_A1012_TV170_FF			0x0034
#define RC5_A1012_TV170_STOP		0x0036

// codes for Jaycar AR1729 ("Digitech") Universal remote on setting 252
#define RC5_AR1729_252_MUTE     	0x016D
#define RC5_AR1729_252_STANDBY  	0x014C

#define RC5_AR1729_252_1			0x0141
#define RC5_AR1729_252_2			0x0142
#define RC5_AR1729_252_3			0x0143
#define RC5_AR1729_252_4			0x0144
#define RC5_AR1729_252_5			0x0145
#define RC5_AR1729_252_6			0x0146
#define RC5_AR1729_252_7			0x0147
#define RC5_AR1729_252_8			0x0148
#define RC5_AR1729_252_9			0x0149
#define RC5_AR1729_252_1_			0x014A
#define RC5_AR1729_252_0			0x0140
#define RC5_AR1729_252_2_			0x014B

#define RC5_AR1729_252_UP			0x016F
#define RC5_AR1729_252_DOWN			0x016A
#define RC5_AR1729_252_LEFT			0x016C
#define RC5_AR1729_252_RIGHT		0x016E
#define RC5_AR1729_252_OK			0x014F

#define RC5_AR1729_252_CHUP			0x0160
#define RC5_AR1729_252_CHDN			0x0161
#define RC5_AR1729_252_VOLUP		0x0150
#define RC5_AR1729_252_VOLDN		0x0151
#define RC5_AR1729_252_MENU			0x017C

#define RC5_AR1729_252_TV_VCR		0x017F
#define RC5_AR1729_252_RECORD		0x0177
#define RC5_AR1729_252_TV_AV		0x0167
#define RC5_AR1729_252_STOP			0x0176
#define RC5_AR1729_252_PLAY			0x0175
#define RC5_AR1729_252_PAUSE		0x0169
#define RC5_AR1729_252_RW			0x0162
#define RC5_AR1729_252_FRAMESTEP	0x0168
#define RC5_AR1729_252_FF			0x0174

// codes for Jaycar AR1729 ("Digitech") Universal remote on setting 102
#define RC5_AR1729_102_MUTE     	0x000D
#define RC5_AR1729_102_STANDBY  	0x000C

#define RC5_AR1729_102_1        	0x0001
#define RC5_AR1729_102_2        	0x0002
#define RC5_AR1729_102_3        	0x0003
#define RC5_AR1729_102_4        	0x0004
#define RC5_AR1729_102_5        	0x0005
#define RC5_AR1729_102_6        	0x0006
#define RC5_AR1729_102_7        	0x0007
#define RC5_AR1729_102_8        	0x0008
#define RC5_AR1729_102_9        	0x0009
#define RC5_AR1729_102_1_       	0x000A
#define RC5_AR1729_102_0        	0x0000
#define RC5_AR1729_102_2_       	0x000B

#define RC5_AR1729_102_UP       	0x0014
#define RC5_AR1729_102_DOWN     	0x0015
#define RC5_AR1729_102_LEFT     	0x0013
#define RC5_AR1729_102_RIGHT    	0x0012
#define RC5_AR1729_102_OK       	0x002F

#define RC5_AR1729_102_CHUP     	0x0020
#define RC5_AR1729_102_CHDN     	0x0021
#define RC5_AR1729_102_VOLUP    	0x0010
#define RC5_AR1729_102_VOLDN    	0x0011
#define RC5_AR1729_102_MENU     	0x003B

#define RC5_AR1729_102_TV_VCR   	0x003F
#define RC5_AR1729_102_RECORD   	0x003C
#define RC5_AR1729_102_TV_AV    	0x0038
#define RC5_AR1729_102_STOP     	0x002C
#define RC5_AR1729_102_PLAY     	0x002B
#define RC5_AR1729_102_PAUSE    	0x0035
#define RC5_AR1729_102_RW       	0x002E
#define RC5_AR1729_102_FRAMESTEP   	0x0029
#define RC5_AR1729_102_FF       	0x002A

// codes for Jaycar AR1729 ("Digitech") Universal remote on setting 281
#define NEC_AR1729_281_MUTE     	0x06D8
#define NEC_AR1729_281_STANDBY		0x06E8

#define NEC_AR1729_281_1        	0x06B0
#define NEC_AR1729_281_2        	0x0670
#define NEC_AR1729_281_3        	0x06F0
#define NEC_AR1729_281_4        	0x0638
#define NEC_AR1729_281_5        	0x06B8
#define NEC_AR1729_281_6        	0x0678
#define NEC_AR1729_281_7        	0x06F8
#define NEC_AR1729_281_8        	0x0620
#define NEC_AR1729_281_9        	0x06A0
//#define NEC_AR1729_281_1_       	nothing sent
#define NEC_AR1729_281_0        	0x0630
//#define NEC_AR1729_281_2_       	nothing sent

#define NEC_AR1729_281_UP       	0x0600
#define NEC_AR1729_281_DOWN     	0x0680
#define NEC_AR1729_281_LEFT     	0x06C0
#define NEC_AR1729_281_RIGHT    	0x0640
#define NEC_AR1729_281_OK       	0x0622

#define NEC_AR1729_281_CHUP     	0x0698
#define NEC_AR1729_281_CHDN     	0x0618
#define NEC_AR1729_281_VOLUP    	0x0648
#define NEC_AR1729_281_VOLDN    	0x06A8
#define NEC_AR1729_281_MENU     	0x0602

#define NEC_AR1729_281_TV_VCR   	0x0668
#define NEC_AR1729_281_RECORD   	0x8628
#define NEC_AR1729_281_TV_AV    	0x067C
#define NEC_AR1729_281_STOP     	0x06D0
#define NEC_AR1729_281_PLAY     	0x0628
#define NEC_AR1729_281_PAUSE    	0x0658
#define NEC_AR1729_281_RW       	0x0650
#define NEC_AR1729_281_FRAMESTEP   	0x0608
#define NEC_AR1729_281_FF       	0x0690

// codes for Digitech Audio remote on default TV setting
#define NEC_0    	  0x0058
#define NEC_1    	  0x0088
#define NEC_2    	  0x0048
#define NEC_3		  0x00C8
#define NEC_4		  0x0028
#define NEC_5		  0x00A8
#define NEC_6		  0x0068
#define NEC_7		  0x00E8
#define NEC_8		  0x0018
#define NEC_9		  0x0098
#define NEC_STANDBY	  0x00C0
#define NEC_MUTE	  0x0080
#define NEC_VOLUP	  0x00B8
#define NEC_VOLDN	  0x0050
#define NEC_MODEUP	  0x00F8
#define NEC_MODEDN	  0x0030
#define NEC_RIGHT	  0x00E0
#define NEC_LEFT	  0x00A0
#define NEC_UP		  0x0020
#define NEC_DOWN	  0x0090

// codes for Altronics A1012 ("DynaLink") remote control on "VCRB" setting 115
#define RC5_A1012_VCRB_MUTE		0x016D

#define RC5_A1012_VCRB_1		0x0141
#define RC5_A1012_VCRB_2		0x0142
#define RC5_A1012_VCRB_3		0x0143
#define RC5_A1012_VCRB_4		0x0144
#define RC5_A1012_VCRB_5		0x0145
#define RC5_A1012_VCRB_6		0x0146
#define RC5_A1012_VCRB_7		0x0147
#define RC5_A1012_VCRB_8		0x0148
#define RC5_A1012_VCRB_9		0x0149
#define RC5_A1012_VCRB_0		0x0140

#define RC5_A1012_VCRB_CHUP		0x0160
#define RC5_A1012_VCRB_CHDN		0x0161
#define RC5_A1012_VCRB_VOLUP	0x0150
#define RC5_A1012_VCRB_VOLDN	0x0151

// codes for Jaycar AR1729 Digitech Universal remote on "VCRB" setting 916
#define RC5_AR1729_VCRB_MUTE    0x014D

#define RC5_AR1729_VCRB_1       0x0141
#define RC5_AR1729_VCRB_2       0x0142
#define RC5_AR1729_VCRB_3       0x0143
#define RC5_AR1729_VCRB_4       0x0144
#define RC5_AR1729_VCRB_5       0x0145
#define RC5_AR1729_VCRB_6       0x0146
#define RC5_AR1729_VCRB_7       0x0147
#define RC5_AR1729_VCRB_8       0x0148
#define RC5_AR1729_VCRB_9       0x0149
#define RC5_AR1729_VCRB_0       0x0140

#define RC5_AR1729_VCRB_CHUP    0x0160
#define RC5_AR1729_VCRB_CHDN    0x0161
#define RC5_AR1729_VCRB_VOLUP   0x0150
#define RC5_AR1729_VCRB_VOLDN   0x0151

void Infrared_Setup();

extern volatile unsigned long ir_final_code;
extern void (*ir_cn_interrupt_chain)(void);

#endif//_INFRARED_H_
